/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.report.htmlreport;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.report.ReportUtilConstants;
import oracle.ops.verification.framework.report.htmlreport.HtmlBrowserException;
import oracle.ops.verification.framework.report.htmlreport.HtmlPage;
import oracle.ops.verification.framework.report.htmlreport.HtmlReportToolException;
import oracle.ops.verification.framework.util.VerificationUtil;

public class HtmlBrowserInterface {
    private static MessageBundle s_rptMsgBundle = VerificationUtil.getMessageBundle("Prve");

    public static void showHtmlInBrowser(HtmlPage page, String browserPath) throws HtmlBrowserException {
        String fileName = "cvucheckreport.html";
        String fullpath = null;
        try {
            fullpath = ReportUtilConstants.createCvuHtmlReportFileAtDefaultPath("cvucheckreport.html");
        }
        catch (ClusterException ce) {
            throw new HtmlBrowserException(ce.getMessage());
        }
        try {
            fullpath = page.saveToFile(fullpath);
        }
        catch (HtmlReportToolException e) {
            e.printStackTrace();
        }
        HtmlBrowserInterface.showHtmlInBrowser(fullpath, browserPath);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void showHtmlInBrowser(String htmlFile, String browserPath) throws HtmlBrowserException {
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        if (!VerificationUtil.isStringGood(htmlFile)) throw new HtmlBrowserException(s_rptMsgBundle.getMessage("10058", false));
        File html = new File(htmlFile);
        if (!html.exists()) return;
        String browser = null;
        if (VerificationUtil.isStringGood(browserPath)) {
            File browserExe = new File(browserPath);
            if (!browserExe.exists()) throw new HtmlBrowserException(s_rptMsgBundle.getMessage("10061", false, (Object[])new String[]{browserPath}));
            browser = browserPath;
        } else if (nativeSystem.isUnixSystem()) {
            String systemBrowser = HtmlBrowserInterface.getBrowserPathOnUnix();
            if (!VerificationUtil.isStringGood(systemBrowser)) throw new HtmlBrowserException(s_rptMsgBundle.getMessage("10062", false));
            File browserExe = new File(systemBrowser);
            if (!browserExe.exists()) throw new HtmlBrowserException(s_rptMsgBundle.getMessage("10061", false, (Object[])new String[]{systemBrowser}));
            browser = systemBrowser;
        }
        try {
            URL url = html.toURL();
            if (nativeSystem.isUnixSystem()) {
                Trace.out((String)("Opening file " + url.toString() + " using browser " + browser));
                Runtime.getRuntime().exec(new String[]{browser, url.toString()});
                return;
            } else {
                Trace.out((String)("Opening file " + url.toString() + " using default browser "));
                Runtime.getRuntime().exec(new String[]{"rundll32 url.dll,FileProtocolHandler", url.toString()});
            }
            return;
        }
        catch (IOException e) {
            throw new HtmlBrowserException(s_rptMsgBundle.getMessage("10063", false, (Object[])new String[]{htmlFile, browser, e.getMessage()}));
        }
    }

    public static String getBrowserPathOnUnix() {
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        String browserPath = null;
        if (nativeSystem.isUnixSystem()) {
            String[] browserList = new String[]{"firefox", "mozilla", "opera", "konqueror", "epiphany"};
            String[] searchCommands = new String[]{"which", "where is"};
            for (String currentBrowser : browserList) {
                for (String cmd : searchCommands) {
                    NativeResult result = new NativeResult();
                    nativeSystem.runRemoteExecCmd(cmd, new String[]{currentBrowser}, null, result);
                    if (!result.getStatus() || !result.getBooleanResult()) continue;
                    String[] cmdOutPut = result.getResultString();
                    if (cmdOutPut == null || cmdOutPut[0] == null) break;
                    browserPath = cmdOutPut[0];
                    break;
                }
                if (VerificationUtil.isStringGood(browserPath)) break;
            }
        }
        return browserPath;
    }
}

